(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[3],{13:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.ALLOW_EMPTY_TARGET = undefined;\nexports.wpseoDeleteRedirect = wpseoDeleteRedirect;\nexports.wpseoRemoveNotification = wpseoRemoveNotification;\nexports.wpseoUndoRedirect = wpseoUndoRedirect;\nexports.wpseoCreateRedirect = wpseoCreateRedirect;\n\nvar _apiFetch = __webpack_require__(14);\n\nvar _apiFetch2 = _interopRequireDefault(_apiFetch);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nvar ALLOW_EMPTY_TARGET = exports.ALLOW_EMPTY_TARGET = [410, 451];\n\n/**\n * Deletes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type   The type of redirect.\n * @param {string} format The format of redirect.\n *\n * @returns {void}\n */\n/* global window, wpApiSettings, wpseoPremiumStrings, ajaxurl */\nfunction wpseoDeleteRedirect(origin, target, type) {\n\tvar format = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "plain";\n\n\treturn (0, _apiFetch2.default)({\n\t\tmethod: "POST",\n\t\turl: wpApiSettings.root + "yoast/v1/redirects/delete",\n\t\theaders: {\n\t\t\t"X-WP-Nonce": wpApiSettings.nonce\n\t\t},\n\t\tdata: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type,\n\t\t\tformat: format\n\t\t}\n\t});\n}\n\n/**\n * Removes a notification.\n *\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoRemoveNotification(source) {\n\tjQuery(source).closest(".yoast-notification").fadeOut("slow");\n}\n\n/**\n * Undoes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type The type of redirect.\n * @param {string} nonce The nonce being used to validate the current AJAX request.\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirect(origin, target, type, nonce, source) {\n\twpseoDeleteRedirect(origin, target, type).then(function (response) {\n\t\tif (response.success === true) {\n\t\t\twpseoRemoveNotification(source);\n\t\t}\n\t});\n}\n\n/**\n * Creates a redirect\n *\n * @param {string} origin The origin.\n * @param {string} type   The redirect type, regex or plain.\n * @param {string} nonce  The nonce.\n * @param {object} source The source of the redirect.\n *\n * @returns {void}\n */\nfunction wpseoCreateRedirect(origin, type, nonce, source) {\n\tvar target = "";\n\n\tif (parseInt(type, 10) !== 410) {\n\t\t/* eslint-disable no-alert */\n\t\ttarget = window.prompt(wpseoPremiumStrings.enter_new_url.replace("%s", origin));\n\t\t/* eslint-enable no-alert */\n\n\t\tif (target === "") {\n\t\t\t/* eslint-disable no-alert */\n\t\t\twindow.alert(wpseoPremiumStrings.error_new_url);\n\t\t\t/* eslint-enable no-alert */\n\t\t\treturn;\n\t\t}\n\t}\n\n\tjQuery.post(ajaxurl, {\n\t\taction: "wpseo_add_redirect_plain",\n\t\t/* eslint-disable-next-line camelcase */\n\t\tajax_nonce: nonce,\n\t\tredirect: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type\n\t\t}\n\t}, function (response) {\n\t\tvar notice = jQuery(source).closest(".yoast-notification");\n\t\t// Remove the classes first.\n\t\tjQuery(notice).removeClass("updated").removeClass("error");\n\n\t\t// Remove possibly added redirect errors.\n\t\tjQuery(notice).find(".redirect_error").remove();\n\n\t\tif (response.error) {\n\t\t\t// Add paragraph on top of the notice with actions and set class to error.\n\t\t\tjQuery(notice).addClass("error").prepend("<p class=\\"redirect_error\\">" + response.error.message + "</p>");\n\n\t\t\treturn;\n\t\t}\n\n\t\t// Parse the success message.\n\t\tvar successMessage = "";\n\t\tif (parseInt(type, 10) === 410) {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved_no_target;\n\t\t} else {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved.replace("%2$s", "<code>" + response.target + "</code>");\n\t\t}\n\n\t\tsuccessMessage = successMessage.replace("%1$s", "<code>" + response.origin + "</code>");\n\n\t\t// Set class to updated and replace html with the success message.\n\t\tjQuery(notice).addClass("updated").html("<p>" + successMessage + "</p>");\n\t}, "json");\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///13\n')},14:function(module,exports){eval("module.exports = window.wp.apiFetch;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTQuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cud3AuYXBpRmV0Y2hcIj9iYzBmIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LndwLmFwaUZldGNoOyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///14\n")},85:function(module,exports,__webpack_require__){"use strict";eval('\n\nvar _functions = __webpack_require__(13);\n\nvar _redirectForm = __webpack_require__(86);\n\nvar _redirectForm2 = _interopRequireDefault(_redirectForm);\n\nvar _validateRedirect = __webpack_require__(87);\n\nvar _validateRedirect2 = _interopRequireDefault(_validateRedirect);\n\nvar _redirectQuickEdit = __webpack_require__(88);\n\nvar _redirectQuickEdit2 = _interopRequireDefault(_redirectQuickEdit);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/* jshint -W097 */\n/* jshint -W098 */\n/* jshint -W107 */\n/* global ajaxurl, wpseoPremiumStrings, _, wpseoUserLocale */\n\n(function ($) {\n\tvar TABLE_COLUMNS = {\n\t\tORIGIN: 1,\n\t\tTARGET: 2,\n\t\tTYPE: 0\n\t};\n\n\tvar KEYS = {\n\t\tENTER: 13\n\t};\n\n\t// Instantiates the quick edit form.\n\tvar redirectsQuickEdit = new _redirectQuickEdit2.default();\n\n\t// Extend the jQuery UI dialog widget for our needs.\n\t$.widget("ui.dialog", $.ui.dialog, {\n\t\t/**\n   * Extends the `_createOverlay` function.\n   *\n   * @returns {void}\n   *\n   * @private\n   */\n\t\t_createOverlay: function _createOverlay() {\n\t\t\tthis._super();\n\t\t\t// If the modal option is true, add a click event on the overlay.\n\t\t\tif (this.options.modal) {\n\t\t\t\tthis._on(this.overlay, {\n\t\t\t\t\t/**\n      * Handles the onclick event for the modal.\n      *\n      * @param {Event} event The event.\n      *\n      * @returns {void}\n      */\n\t\t\t\t\tclick: function click(event) {\n\t\t\t\t\t\tthis.close(event);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t});\n\n\t/**\n  * Extending the elements with a wpseo_redirects object\n  *\n  * @param {string} argType The redirect table.\n  *\n  * @returns {void}\n  */\n\t$.fn.wpseoRedirects = function (argType) {\n\t\tvar that = this;\n\t\tvar redirectFormat = argType.replace("table-", "");\n\n\t\tvar ignore = false;\n\t\tvar lastAction = void 0;\n\n\t\t// The element focus keyboard should be moved back to.\n\t\tvar returnFocusToEl = null;\n\n\t\t/**\n   * Resets the ignore and lastAction.\n   *\n   * @returns {void}\n   */\n\t\tvar resetIgnore = function resetIgnore() {\n\t\t\tignore = false;\n\t\t\tlastAction = null;\n\t\t};\n\n\t\t/**\n   * Creates a button.\n   *\n   * @param {Object}        buttonProps The button value.\n   * @param {function|null} onClick     The event to trigger on click.\n   *\n   * @returns {Object} The button object.\n   */\n\t\tvar createButton = function createButton(buttonProps) {\n\t\t\tvar onClick = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n\t\t\tvar buttonValue = buttonProps.buttonValue,\n\t\t\t    _buttonProps$classNam = buttonProps.className,\n\t\t\t    className = _buttonProps$classNam === undefined ? "button" : _buttonProps$classNam;\n\n\n\t\t\treturn {\n\t\t\t\ttext: buttonValue,\n\t\t\t\t"class": className,\n\n\t\t\t\t/**\n     * Event to trigger onclick.\n     *\n     * @returns {void}\n     */\n\t\t\t\tclick: function click() {\n\t\t\t\t\tif (onClick !== null) {\n\t\t\t\t\t\tonClick();\n\t\t\t\t\t}\n\n\t\t\t\t\tjQuery(this).dialog("close");\n\t\t\t\t}\n\t\t\t};\n\t\t};\n\n\t\tthis.getButtons = function (dialogType) {\n\t\t\tif (dialogType === "default") {\n\t\t\t\treturn [createButton({\n\t\t\t\t\tbuttonValue: wpseoPremiumStrings.button_ok\n\t\t\t\t})];\n\t\t\t}\n\n\t\t\treturn [createButton({\n\t\t\t\tbuttonValue: wpseoPremiumStrings.button_cancel\n\t\t\t}, function () {\n\t\t\t\tresetIgnore();\n\t\t\t}), createButton({\n\t\t\t\tbuttonValue: wpseoPremiumStrings.button_save_anyway,\n\t\t\t\tclassName: "button-primary"\n\t\t\t}, function () {\n\t\t\t\tignore = true;\n\n\t\t\t\t// The value of last action will be the button pressed to save the redirect.\n\t\t\t\tlastAction();\n\n\t\t\t\tresetIgnore();\n\t\t\t})];\n\t\t};\n\n\t\t/**\n   * Returns a mapped object with the row column elements\n   *\n   * @param {Object} row The row object.\n   * @returns {{origin: *, target: *, type: *}} The values of the fields in the row.\n   */\n\t\tthis.rowCells = function (row) {\n\t\t\tvar rowValues = row.find(".val");\n\n\t\t\treturn {\n\t\t\t\torigin: rowValues.eq(TABLE_COLUMNS.ORIGIN),\n\t\t\t\ttarget: rowValues.eq(TABLE_COLUMNS.TARGET),\n\t\t\t\ttype: rowValues.eq(TABLE_COLUMNS.TYPE)\n\t\t\t};\n\t\t};\n\n\t\t/**\n   * Showing a dialog on the screen\n   *\n   * @param {string} title      Dialog title.\n   * @param {string} text       The text for the dialog.\n   * @param {string} dialogType The dialog type.\n   *\n   * @returns {void}\n   */\n\t\tthis.dialog = function (title, text, dialogType) {\n\t\t\tif (typeof dialogType === "undefined" || dialogType === "error") {\n\t\t\t\tdialogType = "default";\n\t\t\t}\n\n\t\t\tvar buttons = this.getButtons(dialogType);\n\n\t\t\t$("#YoastRedirectDialogText").html(text);\n\t\t\t$("#YoastRedirectDialog").dialog({\n\t\t\t\ttitle: title,\n\t\t\t\twidth: 500,\n\t\t\t\tdraggable: false,\n\t\t\t\tresizable: false,\n\t\t\t\tposition: {\n\t\t\t\t\tat: "center center",\n\t\t\t\t\tmy: "center center",\n\t\t\t\t\tof: window\n\t\t\t\t},\n\t\t\t\tbuttons: buttons,\n\t\t\t\tmodal: true,\n\t\t\t\t/**\n     * Focuses the return focus element if set.\n     *\n     * @returns {void}\n     */\n\t\t\t\tclose: function close() {\n\t\t\t\t\tif (returnFocusToEl) {\n\t\t\t\t\t\treturnFocusToEl.focus();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t};\n\n\t\t/**\n   * Handle the response\n   *\n   * @param {object} successMessage The message that will be displayed on success.\n   *\n   * @returns {void}\n   */\n\t\tthis.openDialog = function (successMessage) {\n\t\t\tthis.dialog(successMessage.title, successMessage.message);\n\t\t};\n\n\t\t/**\n   * Sending post request.\n   *\n   * @param {object}   data       The data to post.\n   * @param {function} oncomplete Callback when request has been successful.\n   *\n   * @returns {void}\n   */\n\t\tthis.post = function (data, oncomplete) {\n\t\t\t$.post(ajaxurl, data, oncomplete, "json");\n\t\t};\n\n\t\t/**\n   * Creating an edit row for editing a redirect.\n   *\n   * @param {object} row The row to edit.\n   *\n   * @returns {void}\n   */\n\t\tthis.editRow = function (row) {\n\t\t\t// Just show a dialog when there is already a quick edit form opened.\n\t\t\tif ($("#the-list").find("#inline-edit").length > 0) {\n\t\t\t\t/* eslint-disable camelcase */\n\t\t\t\tthis.dialog(wpseoPremiumStrings.edit_redirect, wpseoPremiumStrings.editing_redirect);\n\t\t\t\t/* eslint-enable camelcase */\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Running the setup and show the quick edit form.\n\t\t\tredirectsQuickEdit.setup(row, this.rowCells(row));\n\t\t\tredirectsQuickEdit.show();\n\n\t\t\tnew _redirectForm2.default(redirectsQuickEdit.quickEditRow).getTypeField().trigger("change");\n\t\t};\n\n\t\t/**\n   * Create a table row element with the new added redirect data\n   *\n   * @param {string} oldUrl       The old url.\n   * @param {string} newUrl       The new url.\n   * @param {string} redirectType The type of the redirect (regex or plain).\n   * @param {Object} redirectInfo  Object with details about the redirect.\n   * @returns {void|*|jQuery} The generated row.\n   */\n\t\tthis.createRedirectRow = function (oldUrl, newUrl, redirectType, redirectInfo) {\n\t\t\tvar targetClasses = ["val"];\n\n\t\t\tif (!redirectInfo.isTargetRelative || "" === newUrl || "/" === newUrl) {\n\t\t\t\ttargetClasses.push("remove-slashes");\n\t\t\t}\n\n\t\t\tif (redirectInfo.hasTrailingSlash) {\n\t\t\t\ttargetClasses.push("has-trailing-slash");\n\t\t\t}\n\n\t\t\treturn $("<tr>").append($("<th>").addClass("check-column").attr("scope", "row").append($("<input>").attr("name", "wpseo_redirects_bulk_delete[]").attr("type", "checkbox").val(_.escape(oldUrl)))).append($("<td>").addClass("type column-type has-row-actions column-primary").append($("<div>").addClass("val type").html(_.escape(redirectType))).append($("<div>").addClass("row-actions").append($("<span>").addClass("edit").append($("<a>").attr({ href: "#", role: "button", "class": "redirect-edit" }).html(wpseoPremiumStrings.editAction)).append(" | ")).append($("<span>").addClass("trash").append($("<a>").attr({ href: "#", role: "button", "class": "redirect-delete" }).html(wpseoPremiumStrings.deleteAction))))).append($("<td>").addClass("column-old").append($("<div>").addClass("val").html(_.escape(oldUrl)))).append($("<td>").addClass("column-new").append($("<div>").addClass(targetClasses.join(" ")).html(_.escape(newUrl))));\n\t\t};\n\n\t\t/**\n   * Handles the error.\n   *\n   * @param {ValidateRedirect} validateRedirect The validation object.\n   * @param {Object}           error            The error object.\n   *\n   * @returns {void}\n   */\n\t\tthis.handleError = function (validateRedirect, error) {\n\t\t\tvalidateRedirect.addValidationError(error.message, error.fields);\n\n\t\t\tif (error.type === "warning") {\n\t\t\t\tthat.dialog(wpseoPremiumStrings.error_saving_redirect, error.message, error.type);\n\t\t\t}\n\t\t};\n\n\t\t/**\n   * Adding the redirect\n   *\n   * @returns {boolean} True when redirect has been added successfully.\n   */\n\t\tthis.addRedirect = function () {\n\t\t\t// Do the validation.\n\t\t\tvar redirectForm = new _redirectForm2.default($(".wpseo-new-redirect-form"));\n\t\t\tvar validateRedirect = new _validateRedirect2.default(redirectForm, redirectFormat);\n\t\t\tif (validateRedirect.validate() === false) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tvar redirectValues = validateRedirect.getFormValues();\n\n\t\t\t// Do post.\n\t\t\tthat.post({\n\t\t\t\taction: "wpseo_add_redirect_" + redirectFormat,\n\t\t\t\t/* eslint-disable-next-line camelcase */\n\t\t\t\tajax_nonce: $(".wpseo_redirects_ajax_nonce").val(),\n\t\t\t\tredirect: {\n\t\t\t\t\torigin: encodeURIComponent(redirectValues.origin),\n\t\t\t\t\ttarget: encodeURIComponent(redirectValues.target),\n\t\t\t\t\ttype: redirectValues.type\n\t\t\t\t},\n\t\t\t\t/* eslint-disable-next-line camelcase */\n\t\t\t\tignore_warning: ignore\n\t\t\t}, function (response) {\n\t\t\t\tif (response.error) {\n\t\t\t\t\tthat.handleError(validateRedirect, response.error);\n\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\n\t\t\t\t// Empty the form fields.\n\t\t\t\tredirectForm.getOriginField().val("");\n\t\t\t\tredirectForm.getTargetField().val("");\n\n\t\t\t\t// Remove the no items row.\n\t\t\t\tthat.find(".no-items").remove();\n\n\t\t\t\t// Creating tr.\n\t\t\t\tvar tr = that.createRedirectRow(response.origin, response.target, response.type, response.info);\n\n\t\t\t\t// Add the new row.\n\t\t\t\t$("form#" + redirectFormat).find("#the-list").prepend(tr);\n\n\t\t\t\tthat.openDialog(wpseoPremiumStrings.redirect_added);\n\t\t\t});\n\n\t\t\treturn true;\n\t\t};\n\n\t\t/**\n   * Updating the redirect\n   *\n   * @returns {boolean} True when updates is successful.\n   */\n\t\tthis.updateRedirect = function () {\n\t\t\t// Do the validation.\n\t\t\tvar redirectForm = new _redirectForm2.default(redirectsQuickEdit.getForm());\n\t\t\tvar validateRedirect = new _validateRedirect2.default(redirectForm, redirectFormat);\n\t\t\tif (validateRedirect.validate() === false) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tvar redirectValues = validateRedirect.getFormValues();\n\n\t\t\t// Setting the vars for the row and its values.\n\t\t\tvar row = redirectsQuickEdit.getRow();\n\t\t\tvar rowCells = this.rowCells(row);\n\n\t\t\t// Post the request.\n\t\t\tthat.post({\n\t\t\t\t/* eslint-disable camelcase */\n\t\t\t\taction: "wpseo_update_redirect_" + redirectFormat,\n\t\t\t\tajax_nonce: $(".wpseo_redirects_ajax_nonce").val(),\n\t\t\t\told_redirect: {\n\t\t\t\t\torigin: encodeURIComponent(rowCells.origin.html()),\n\t\t\t\t\ttarget: encodeURIComponent(rowCells.target.html()),\n\t\t\t\t\ttype: encodeURIComponent(rowCells.type.html())\n\t\t\t\t},\n\t\t\t\tnew_redirect: {\n\t\t\t\t\torigin: encodeURIComponent(redirectValues.origin),\n\t\t\t\t\ttarget: encodeURIComponent(redirectValues.target),\n\t\t\t\t\ttype: encodeURIComponent(redirectValues.type)\n\t\t\t\t},\n\t\t\t\tignore_warning: ignore\n\t\t\t}, function (response) {\n\t\t\t\tif (response.error) {\n\t\t\t\t\tthat.handleError(validateRedirect, response.error);\n\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\n\t\t\t\t// Updates the table cells.\n\t\t\t\trowCells.origin.html(_.escape(response.origin));\n\t\t\t\trowCells.target.html(_.escape(response.target));\n\t\t\t\trowCells.type.html(_.escape(response.type));\n\n\t\t\t\tredirectsQuickEdit.remove();\n\n\t\t\t\tthat.openDialog(wpseoPremiumStrings.redirect_updated);\n\t\t\t}\n\t\t\t/* eslint-enable camelcase */\n\t\t\t);\n\n\t\t\treturn true;\n\t\t};\n\n\t\t/**\n   * Removes the redirect\n   *\n   * @param {Object} row The row object.\n   *\n   * @returns {void}\n   */\n\t\tthis.deleteRedirect = function (row) {\n\t\t\tvar _this = this;\n\n\t\t\tvar rowCells = this.rowCells(row);\n\n\t\t\tvar origin = rowCells.origin.html();\n\t\t\tvar target = rowCells.target.html();\n\t\t\tvar redirectType = rowCells.type.html();\n\n\t\t\t(0, _functions.wpseoDeleteRedirect)(origin, target, redirectType, redirectFormat).then(function (response) {\n\t\t\t\t// When the redirect is removed, just fade out the row and remove it after its faded.\n\t\t\t\trow.fadeTo("fast", 0).slideUp(function () {\n\t\t\t\t\t$(this).remove();\n\t\t\t\t});\n\n\t\t\t\tthat.openDialog(response);\n\t\t\t}).catch(function (error) {\n\t\t\t\t_this.dialog(error.title, error.message, "error");\n\t\t\t});\n\t\t};\n\n\t\t/**\n   * Running the setup of this element.\n   *\n   * @returns {void}\n   */\n\t\tthis.setup = function () {\n\t\t\tvar $row = void 0;\n\t\t\t// Adding dialog.\n\t\t\t$("body").append("<div id=\\"YoastRedirectDialog\\"><div id=\\"YoastRedirectDialogText\\"></div></div>");\n\n\t\t\t// When the window will be closed/reloaded and there is a inline edit opened show a message.\n\t\t\t$(window).on("beforeunload", function () {\n\t\t\t\tif ($("#the-list").find("#inline-edit").length > 0) {\n\t\t\t\t\treturn wpseoPremiumStrings.unsaved_redirects;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Adding the onchange event.\n\t\t\t$(".redirect-table-tab").on("change", "select[name=wpseo_redirects_type]", function (evt) {\n\t\t\t\tvar redirectType = parseInt($(evt.target).val(), 10);\n\t\t\t\tvar fieldToToggle = $(evt.target).closest(".wpseo_redirect_form").find(".wpseo_redirect_target_holder");\n\n\t\t\t\t// Hide the target field in case of a 410 redirect.\n\t\t\t\tif (jQuery.inArray(redirectType, _functions.ALLOW_EMPTY_TARGET) > -1) {\n\t\t\t\t\t$(fieldToToggle).hide();\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\t$(fieldToToggle).show();\n\t\t\t});\n\n\t\t\t// Adding events for the add form.\n\t\t\t$(".wpseo-new-redirect-form").on("click", ".button-primary", function () {\n\t\t\t\tlastAction = function lastAction() {\n\t\t\t\t\tthat.addRedirect();\n\t\t\t\t};\n\n\t\t\t\tthat.addRedirect();\n\t\t\t\treturnFocusToEl = $(this);\n\t\t\t\treturn false;\n\t\t\t}).on("keypress", "input", function (evt) {\n\t\t\t\tif (evt.which === KEYS.ENTER) {\n\t\t\t\t\tlastAction = function lastAction() {\n\t\t\t\t\t\tthat.addRedirect();\n\t\t\t\t\t};\n\n\t\t\t\t\tevt.preventDefault();\n\t\t\t\t\tthat.addRedirect();\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t$(".wp-list-table").on("click", ".redirect-edit", function (evt) {\n\t\t\t\t$row = $(evt.target).closest("tr");\n\n\t\t\t\tevt.preventDefault();\n\t\t\t\tthat.editRow($row);\n\t\t\t\treturnFocusToEl = $(this);\n\t\t\t}).on("click", ".redirect-delete", function (evt) {\n\t\t\t\t$row = $(evt.target).closest("tr");\n\n\t\t\t\tevt.preventDefault();\n\t\t\t\tthat.deleteRedirect($row);\n\t\t\t\t// When a row gets deleted, where focus should land?\n\t\t\t\treturnFocusToEl = $("#cb-select-all-1");\n\t\t\t}).on("keypress", "input", function (evt) {\n\t\t\t\tif (evt.which === KEYS.ENTER) {\n\t\t\t\t\tlastAction = function lastAction() {\n\t\t\t\t\t\tthat.updateRedirect();\n\t\t\t\t\t};\n\n\t\t\t\t\tevt.preventDefault();\n\t\t\t\t\tthat.updateRedirect();\n\t\t\t\t}\n\t\t\t}).on("click", ".save", function () {\n\t\t\t\tlastAction = function lastAction() {\n\t\t\t\t\tthat.updateRedirect();\n\t\t\t\t};\n\n\t\t\t\tlastAction();\n\t\t\t}).on("click", ".cancel", function () {\n\t\t\t\tlastAction = null;\n\t\t\t\tredirectsQuickEdit.remove();\n\t\t\t\t// Move focus back to the Edit link.\n\t\t\t\t$row.find(".redirect-edit").focus();\n\t\t\t});\n\t\t};\n\n\t\tthat.setup();\n\t};\n\n\t/**\n  * Adds select2 for selected fields.\n  *\n  * @returns {void}\n  */\n\tfunction initSelect2() {\n\t\t$("#wpseo_redirects_type").select2({\n\t\t\twidth: "400px",\n\t\t\tlanguage: wpseoUserLocale,\n\t\t\tdropdownCssClass: "yoast-select__dropdown"\n\t\t});\n\t}\n\n\t/**\n  * Initializes the redirect page.\n  *\n  * @returns {void}\n  */\n\tfunction init() {\n\t\t$.each($(".redirect-table-tab"), function (key, element) {\n\t\t\t$(element).wpseoRedirects($(element).attr("id"));\n\t\t});\n\n\t\tinitSelect2();\n\t}\n\n\t$(init);\n})(jQuery);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiODUuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vYXNzZXRzL2pzL3NyYy9hZG1pbi1yZWRpcmVjdHMuanM/NGJlNiJdLCJzb3VyY2VzQ29udGVudCI6WyIvKiBqc2hpbnQgLVcwOTcgKi9cbi8qIGpzaGludCAtVzA5OCAqL1xuLyoganNoaW50IC1XMTA3ICovXG4vKiBnbG9iYWwgYWpheHVybCwgd3BzZW9QcmVtaXVtU3RyaW5ncywgXywgd3BzZW9Vc2VyTG9jYWxlICovXG5cbmltcG9ydCB7IHdwc2VvRGVsZXRlUmVkaXJlY3QsIEFMTE9XX0VNUFRZX1RBUkdFVCB9IGZyb20gXCIuL3JlZGlyZWN0cy9mdW5jdGlvbnNcIjtcbmltcG9ydCBSZWRpcmVjdEZvcm0gZnJvbSBcIi4vcmVkaXJlY3RzL3JlZGlyZWN0LWZvcm1cIjtcbmltcG9ydCBWYWxpZGF0ZVJlZGlyZWN0IGZyb20gXCIuL3JlZGlyZWN0cy92YWxpZGF0ZS1yZWRpcmVjdFwiO1xuaW1wb3J0IFJlZGlyZWN0UXVpY2tFZGl0IGZyb20gXCIuL3JlZGlyZWN0cy9yZWRpcmVjdC1xdWljay1lZGl0XCI7XG5cbiggZnVuY3Rpb24oICQgKSB7XG5cdGNvbnN0IFRBQkxFX0NPTFVNTlMgPSB7XG5cdFx0T1JJR0lOOiAxLFxuXHRcdFRBUkdFVDogMixcblx0XHRUWVBFOiAwLFxuXHR9O1xuXG5cdGNvbnN0IEtFWVMgPSB7XG5cdFx0RU5URVI6IDEzLFxuXHR9O1xuXG5cdC8vIEluc3RhbnRpYXRlcyB0aGUgcXVpY2sgZWRpdCBmb3JtLlxuXHRjb25zdCByZWRpcmVjdHNRdWlja0VkaXQgPSBuZXcgUmVkaXJlY3RRdWlja0VkaXQoKTtcblxuXHQvLyBFeHRlbmQgdGhlIGpRdWVyeSBVSSBkaWFsb2cgd2lkZ2V0IGZvciBvdXIgbmVlZHMuXG5cdCQud2lkZ2V0KCBcInVpLmRpYWxvZ1wiLCAkLnVpLmRpYWxvZywge1xuXHRcdC8qKlxuXHRcdCAqIEV4dGVuZHMgdGhlIGBfY3JlYXRlT3ZlcmxheWAgZnVuY3Rpb24uXG5cdFx0ICpcblx0XHQgKiBAcmV0dXJucyB7dm9pZH1cblx0XHQgKlxuXHRcdCAqIEBwcml2YXRlXG5cdFx0ICovXG5cdFx0X2NyZWF0ZU92ZXJsYXk6IGZ1bmN0aW9uKCkge1xuXHRcdFx0dGhpcy5fc3VwZXIoKTtcblx0XHRcdC8vIElmIHRoZSBtb2RhbCBvcHRpb24gaXMgdHJ1ZSwgYWRkIGEgY2xpY2sgZXZlbnQgb24gdGhlIG92ZXJsYXkuXG5cdFx0XHRpZiAoIHRoaXMub3B0aW9ucy5tb2RhbCApIHtcblx0XHRcdFx0dGhpcy5fb24oIHRoaXMub3ZlcmxheSwge1xuXHRcdFx0XHRcdC8qKlxuXHRcdFx0XHRcdCAqIEhhbmRsZXMgdGhlIG9uY2xpY2sgZXZlbnQgZm9yIHRoZSBtb2RhbC5cblx0XHRcdFx0XHQgKlxuXHRcdFx0XHRcdCAqIEBwYXJhbSB7RXZlbnR9IGV2ZW50IFRoZSBldmVudC5cblx0XHRcdFx0XHQgKlxuXHRcdFx0XHRcdCAqIEByZXR1cm5zIHt2b2lkfVxuXHRcdFx0XHRcdCAqL1xuXHRcdFx0XHRcdGNsaWNrOiBmdW5jdGlvbiggZXZlbnQgKSB7XG5cdFx0XHRcdFx0XHR0aGlzLmNsb3NlKCBldmVudCApO1xuXHRcdFx0XHRcdH0sXG5cdFx0XHRcdH0gKTtcblx0XHRcdH1cblx0XHR9LFxuXHR9ICk7XG5cblx0LyoqXG5cdCAqIEV4dGVuZGluZyB0aGUgZWxlbWVudHMgd2l0aCBhIHdwc2VvX3JlZGlyZWN0cyBvYmplY3Rcblx0ICpcblx0ICogQHBhcmFtIHtzdHJpbmd9IGFyZ1R5cGUgVGhlIHJlZGlyZWN0IHRhYmxlLlxuXHQgKlxuXHQgKiBAcmV0dXJucyB7dm9pZH1cblx0ICovXG5cdCQuZm4ud3BzZW9SZWRpcmVjdHMgPSBmdW5jdGlvbiggYXJnVHlwZSApIHtcblx0XHRjb25zdCB0aGF0ICAgICAgICAgICA9IHRoaXM7XG5cdFx0Y29uc3QgcmVkaXJlY3RGb3JtYXQgPSBhcmdUeXBlLnJlcGxhY2UoIFwidGFibGUtXCIsIFwiXCIgKTtcblxuXHRcdGxldCBpZ25vcmUgPSBmYWxzZTtcblx0XHRsZXQgbGFzdEFjdGlvbjtcblxuXHRcdC8vIFRoZSBlbGVtZW50IGZvY3VzIGtleWJvYXJkIHNob3VsZCBiZSBtb3ZlZCBiYWNrIHRvLlxuXHRcdGxldCByZXR1cm5Gb2N1c1RvRWwgPSBudWxsO1xuXG5cdFx0LyoqXG5cdFx0ICogUmVzZXRzIHRoZSBpZ25vcmUgYW5kIGxhc3RBY3Rpb24uXG5cdFx0ICpcblx0XHQgKiBAcmV0dXJucyB7dm9pZH1cblx0XHQgKi9cblx0XHRjb25zdCByZXNldElnbm9yZSA9IGZ1bmN0aW9uKCkge1xuXHRcdFx0aWdub3JlICAgICA9IGZhbHNlO1xuXHRcdFx0bGFzdEFjdGlvbiA9IG51bGw7XG5cdFx0fTtcblxuXHRcdC8qKlxuXHRcdCAqIENyZWF0ZXMgYSBidXR0b24uXG5cdFx0ICpcblx0XHQgKiBAcGFyYW0ge09iamVjdH0gICAgICAgIGJ1dHRvblByb3BzIFRoZSBidXR0b24gdmFsdWUuXG5cdFx0ICogQHBhcmFtIHtmdW5jdGlvbnxudWxsfSBvbkNsaWNrICAgICBUaGUgZXZlbnQgdG8gdHJpZ2dlciBvbiBjbGljay5cblx0XHQgKlxuXHRcdCAqIEByZXR1cm5zIHtPYmplY3R9IFRoZSBidXR0b24gb2JqZWN0LlxuXHRcdCAqL1xuXHRcdGNvbnN0IGNyZWF0ZUJ1dHRvbiA9ICggYnV0dG9uUHJvcHMsIG9uQ2xpY2sgPSBudWxsICkgPT4ge1xuXHRcdFx0Y29uc3QgeyBidXR0b25WYWx1ZSwgY2xhc3NOYW1lID0gXCJidXR0b25cIiB9ID0gYnV0dG9uUHJvcHM7XG5cblx0XHRcdHJldHVybiB7XG5cdFx0XHRcdHRleHQ6IGJ1dHRvblZhbHVlLFxuXHRcdFx0XHRcImNsYXNzXCI6IGNsYXNzTmFtZSxcblxuXHRcdFx0XHQvKipcblx0XHRcdFx0ICogRXZlbnQgdG8gdHJpZ2dlciBvbmNsaWNrLlxuXHRcdFx0XHQgKlxuXHRcdFx0XHQgKiBAcmV0dXJucyB7dm9pZH1cblx0XHRcdFx0ICovXG5cdFx0XHRcdGNsaWNrOiBmdW5jdGlvbigpIHtcblx0XHRcdFx0XHRpZiAoIG9uQ2xpY2sgIT09IG51bGwgKSB7XG5cdFx0XHRcdFx0XHRvbkNsaWNrKCk7XG5cdFx0XHRcdFx0fVxuXG5cdFx0XHRcdFx0alF1ZXJ5KCB0aGlzICkuZGlhbG9nKCBcImNsb3NlXCIgKTtcblx0XHRcdFx0fSxcblx0XHRcdH07XG5cdFx0fTtcblxuXHRcdHRoaXMuZ2V0QnV0dG9ucyA9IGZ1bmN0aW9uKCBkaWFsb2dUeXBlICkge1xuXHRcdFx0aWYgKCBkaWFsb2dUeXBlID09PSBcImRlZmF1bHRcIiApIHtcblx0XHRcdFx0cmV0dXJuIFtcblx0XHRcdFx0XHRjcmVhdGVCdXR0b24oXG5cdFx0XHRcdFx0XHR7XG5cdFx0XHRcdFx0XHRcdGJ1dHRvblZhbHVlOiB3cHNlb1ByZW1pdW1TdHJpbmdzLmJ1dHRvbl9vayxcblx0XHRcdFx0XHRcdH1cblx0XHRcdFx0XHQpLFxuXHRcdFx0XHRdO1xuXHRcdFx0fVxuXG5cdFx0XHRyZXR1cm4gW1xuXHRcdFx0XHRjcmVhdGVCdXR0b24oXG5cdFx0XHRcdFx0e1xuXHRcdFx0XHRcdFx0YnV0dG9uVmFsdWU6IHdwc2VvUHJlbWl1bVN0cmluZ3MuYnV0dG9uX2NhbmNlbCxcblx0XHRcdFx0XHR9LFxuXHRcdFx0XHRcdCgpID0+IHtcblx0XHRcdFx0XHRcdHJlc2V0SWdub3JlKCk7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHQpLFxuXHRcdFx0XHRjcmVhdGVCdXR0b24oXG5cdFx0XHRcdFx0e1xuXHRcdFx0XHRcdFx0YnV0dG9uVmFsdWU6IHdwc2VvUHJlbWl1bVN0cmluZ3MuYnV0dG9uX3NhdmVfYW55d2F5LFxuXHRcdFx0XHRcdFx0Y2xhc3NOYW1lOiBcImJ1dHRvbi1wcmltYXJ5XCIsXG5cdFx0XHRcdFx0fSxcblx0XHRcdFx0XHQoKSA9PiB7XG5cdFx0XHRcdFx0XHRpZ25vcmUgPSB0cnVlO1xuXG5cdFx0XHRcdFx0XHQvLyBUaGUgdmFsdWUgb2YgbGFzdCBhY3Rpb24gd2lsbCBiZSB0aGUgYnV0dG9uIHByZXNzZWQgdG8gc2F2ZSB0aGUgcmVkaXJlY3QuXG5cdFx0XHRcdFx0XHRsYXN0QWN0aW9uKCk7XG5cblx0XHRcdFx0XHRcdHJlc2V0SWdub3JlKCk7XG5cdFx0XHRcdFx0fVxuXHRcdFx0XHQpLFxuXHRcdFx0XTtcblx0XHR9O1xuXG5cdFx0LyoqXG5cdFx0ICogUmV0dXJucyBhIG1hcHBlZCBvYmplY3Qgd2l0aCB0aGUgcm93IGNvbHVtbiBlbGVtZW50c1xuXHRcdCAqXG5cdFx0ICogQHBhcmFtIHtPYmplY3R9IHJvdyBUaGUgcm93IG9iamVjdC5cblx0XHQgKiBAcmV0dXJucyB7e29yaWdpbjogKiwgdGFyZ2V0OiAqLCB0eXBlOiAqfX0gVGhlIHZhbHVlcyBvZiB0aGUgZmllbGRzIGluIHRoZSByb3cuXG5cdFx0ICovXG5cdFx0dGhpcy5yb3dDZWxscyA9IGZ1bmN0aW9uKCByb3cgKSB7XG5cdFx0XHRjb25zdCByb3dWYWx1ZXMgPSByb3cuZmluZCggXCIudmFsXCIgKTtcblxuXHRcdFx0cmV0dXJuIHtcblx0XHRcdFx0b3JpZ2luOiByb3dWYWx1ZXMuZXEoIFRBQkxFX0NPTFVNTlMuT1JJR0lOICksXG5cdFx0XHRcdHRhcmdldDogcm93VmFsdWVzLmVxKCBUQUJMRV9DT0xVTU5TLlRBUkdFVCApLFxuXHRcdFx0XHR0eXBlOiByb3dWYWx1ZXMuZXEoIFRBQkxFX0NPTFVNTlMuVFlQRSApLFxuXHRcdFx0fTtcblx0XHR9O1xuXG5cdFx0LyoqXG5cdFx0ICogU2hvd2luZyBhIGRpYWxvZyBvbiB0aGUgc2NyZWVuXG5cdFx0ICpcblx0XHQgKiBAcGFyYW0ge3N0cmluZ30gdGl0bGUgICAgICBEaWFsb2cgdGl0bGUuXG5cdFx0ICogQHBhcmFtIHtzdHJpbmd9IHRleHQgICAgICAgVGhlIHRleHQgZm9yIHRoZSBkaWFsb2cuXG5cdFx0ICogQHBhcmFtIHtzdHJpbmd9IGRpYWxvZ1R5cGUgVGhlIGRpYWxvZyB0eXBlLlxuXHRcdCAqXG5cdFx0ICogQHJldHVybnMge3ZvaWR9XG5cdFx0ICovXG5cdFx0dGhpcy5kaWFsb2cgPSBmdW5jdGlvbiggdGl0bGUsIHRleHQsIGRpYWxvZ1R5cGUgKSB7XG5cdFx0XHRpZiAoIHR5cGVvZiBkaWFsb2dUeXBlID09PSBcInVuZGVmaW5lZFwiIHx8IGRpYWxvZ1R5cGUgPT09IFwiZXJyb3JcIiApIHtcblx0XHRcdFx0ZGlhbG9nVHlwZSA9IFwiZGVmYXVsdFwiO1xuXHRcdFx0fVxuXG5cdFx0XHRjb25zdCBidXR0b25zID0gdGhpcy5nZXRCdXR0b25zKCBkaWFsb2dUeXBlICk7XG5cblx0XHRcdCQoIFwiI1lvYXN0UmVkaXJlY3REaWFsb2dUZXh0XCIgKS5odG1sKCB0ZXh0ICk7XG5cdFx0XHQkKCBcIiNZb2FzdFJlZGlyZWN0RGlhbG9nXCIgKS5kaWFsb2coXG5cdFx0XHRcdHtcblx0XHRcdFx0XHR0aXRsZTogdGl0bGUsXG5cdFx0XHRcdFx0d2lkdGg6IDUwMCxcblx0XHRcdFx0XHRkcmFnZ2FibGU6IGZhbHNlLFxuXHRcdFx0XHRcdHJlc2l6YWJsZTogZmFsc2UsXG5cdFx0XHRcdFx0cG9zaXRpb246IHtcblx0XHRcdFx0XHRcdGF0OiBcImNlbnRlciBjZW50ZXJcIixcblx0XHRcdFx0XHRcdG15OiBcImNlbnRlciBjZW50ZXJcIixcblx0XHRcdFx0XHRcdG9mOiB3aW5kb3csXG5cdFx0XHRcdFx0fSxcblx0XHRcdFx0XHRidXR0b25zOiBidXR0b25zLFxuXHRcdFx0XHRcdG1vZGFsOiB0cnVlLFxuXHRcdFx0XHRcdC8qKlxuXHRcdFx0XHRcdCAqIEZvY3VzZXMgdGhlIHJldHVybiBmb2N1cyBlbGVtZW50IGlmIHNldC5cblx0XHRcdFx0XHQgKlxuXHRcdFx0XHRcdCAqIEByZXR1cm5zIHt2b2lkfVxuXHRcdFx0XHRcdCAqL1xuXHRcdFx0XHRcdGNsb3NlOiBmdW5jdGlvbigpIHtcblx0XHRcdFx0XHRcdGlmICggcmV0dXJuRm9jdXNUb0VsICkge1xuXHRcdFx0XHRcdFx0XHRyZXR1cm5Gb2N1c1RvRWwuZm9jdXMoKTtcblx0XHRcdFx0XHRcdH1cblx0XHRcdFx0XHR9LFxuXHRcdFx0XHR9XG5cdFx0XHQpO1xuXHRcdH07XG5cblx0XHQvKipcblx0XHQgKiBIYW5kbGUgdGhlIHJlc3BvbnNlXG5cdFx0ICpcblx0XHQgKiBAcGFyYW0ge29iamVjdH0gc3VjY2Vzc01lc3NhZ2UgVGhlIG1lc3NhZ2UgdGhhdCB3aWxsIGJlIGRpc3BsYXllZCBvbiBzdWNjZXNzLlxuXHRcdCAqXG5cdFx0ICogQHJldHVybnMge3ZvaWR9XG5cdFx0ICovXG5cdFx0dGhpcy5vcGVuRGlhbG9nID0gZnVuY3Rpb24oIHN1Y2Nlc3NNZXNzYWdlICkge1xuXHRcdFx0dGhpcy5kaWFsb2coIHN1Y2Nlc3NNZXNzYWdlLnRpdGxlLCBzdWNjZXNzTWVzc2FnZS5tZXNzYWdlICk7XG5cdFx0fTtcblxuXHRcdC8qKlxuXHRcdCAqIFNlbmRpbmcgcG9zdCByZXF1ZXN0LlxuXHRcdCAqXG5cdFx0ICogQHBhcmFtIHtvYmplY3R9ICAgZGF0YSAgICAgICBUaGUgZGF0YSB0byBwb3N0LlxuXHRcdCAqIEBwYXJhbSB7ZnVuY3Rpb259IG9uY29tcGxldGUgQ2FsbGJhY2sgd2hlbiByZXF1ZXN0IGhhcyBiZWVuIHN1Y2Nlc3NmdWwuXG5cdFx0ICpcblx0XHQgKiBAcmV0dXJucyB7dm9pZH1cblx0XHQgKi9cblx0XHR0aGlzLnBvc3QgPSBmdW5jdGlvbiggZGF0YSwgb25jb21wbGV0ZSApIHtcblx0XHRcdCQucG9zdCggYWpheHVybCwgZGF0YSwgb25jb21wbGV0ZSwgXCJqc29uXCIgKTtcblx0XHR9O1xuXG5cdFx0LyoqXG5cdFx0ICogQ3JlYXRpbmcgYW4gZWRpdCByb3cgZm9yIGVkaXRpbmcgYSByZWRpcmVjdC5cblx0XHQgKlxuXHRcdCAqIEBwYXJhbSB7b2JqZWN0fSByb3cgVGhlIHJvdyB0byBlZGl0LlxuXHRcdCAqXG5cdFx0ICogQHJldHVybnMge3ZvaWR9XG5cdFx0ICovXG5cdFx0dGhpcy5lZGl0Um93ID0gZnVuY3Rpb24oIHJvdyApIHtcblx0XHRcdC8vIEp1c3Qgc2hvdyBhIGRpYWxvZyB3aGVuIHRoZXJlIGlzIGFscmVhZHkgYSBxdWljayBlZGl0IGZvcm0gb3BlbmVkLlxuXHRcdFx0aWYgKCAkKCBcIiN0aGUtbGlzdFwiICkuZmluZCggXCIjaW5saW5lLWVkaXRcIiApLmxlbmd0aCA+IDAgKSB7XG5cdFx0XHRcdC8qIGVzbGludC1kaXNhYmxlIGNhbWVsY2FzZSAqL1xuXHRcdFx0XHR0aGlzLmRpYWxvZyhcblx0XHRcdFx0XHR3cHNlb1ByZW1pdW1TdHJpbmdzLmVkaXRfcmVkaXJlY3QsXG5cdFx0XHRcdFx0d3BzZW9QcmVtaXVtU3RyaW5ncy5lZGl0aW5nX3JlZGlyZWN0XG5cdFx0XHRcdCk7XG5cdFx0XHRcdC8qIGVzbGludC1lbmFibGUgY2FtZWxjYXNlICovXG5cblx0XHRcdFx0cmV0dXJuO1xuXHRcdFx0fVxuXG5cdFx0XHQvLyBSdW5uaW5nIHRoZSBzZXR1cCBhbmQgc2hvdyB0aGUgcXVpY2sgZWRpdCBmb3JtLlxuXHRcdFx0cmVkaXJlY3RzUXVpY2tFZGl0LnNldHVwKCByb3csIHRoaXMucm93Q2VsbHMoIHJvdyApICk7XG5cdFx0XHRyZWRpcmVjdHNRdWlja0VkaXQuc2hvdygpO1xuXG5cdFx0XHRuZXcgUmVkaXJlY3RGb3JtKCByZWRpcmVjdHNRdWlja0VkaXQucXVpY2tFZGl0Um93ICkuZ2V0VHlwZUZpZWxkKCkudHJpZ2dlciggXCJjaGFuZ2VcIiApO1xuXHRcdH07XG5cblx0XHQvKipcblx0XHQgKiBDcmVhdGUgYSB0YWJsZSByb3cgZWxlbWVudCB3aXRoIHRoZSBuZXcgYWRkZWQgcmVkaXJlY3QgZGF0YVxuXHRcdCAqXG5cdFx0ICogQHBhcmFtIHtzdHJpbmd9IG9sZFVybCAgICAgICBUaGUgb2xkIHVybC5cblx0XHQgKiBAcGFyYW0ge3N0cmluZ30gbmV3VXJsICAgICAgIFRoZSBuZXcgdXJsLlxuXHRcdCAqIEBwYXJhbSB7c3RyaW5nfSByZWRpcmVjdFR5cGUgVGhlIHR5cGUgb2YgdGhlIHJlZGlyZWN0IChyZWdleCBvciBwbGFpbikuXG5cdFx0ICogQHBhcmFtIHtPYmplY3R9IHJlZGlyZWN0SW5mbyAgT2JqZWN0IHdpdGggZGV0YWlscyBhYm91dCB0aGUgcmVkaXJlY3QuXG5cdFx0ICogQHJldHVybnMge3ZvaWR8KnxqUXVlcnl9IFRoZSBnZW5lcmF0ZWQgcm93LlxuXHRcdCAqL1xuXHRcdHRoaXMuY3JlYXRlUmVkaXJlY3RSb3cgPSBmdW5jdGlvbiggb2xkVXJsLCBuZXdVcmwsIHJlZGlyZWN0VHlwZSwgcmVkaXJlY3RJbmZvICkge1xuXHRcdFx0Y29uc3QgdGFyZ2V0Q2xhc3NlcyA9IFsgXCJ2YWxcIiBdO1xuXG5cdFx0XHRpZiAoXG5cdFx0XHRcdCEgcmVkaXJlY3RJbmZvLmlzVGFyZ2V0UmVsYXRpdmUgfHxcblx0XHRcdFx0XCJcIiA9PT0gbmV3VXJsIHx8XG5cdFx0XHRcdFwiL1wiID09PSBuZXdVcmxcblx0XHRcdCkge1xuXHRcdFx0XHR0YXJnZXRDbGFzc2VzLnB1c2goIFwicmVtb3ZlLXNsYXNoZXNcIiApO1xuXHRcdFx0fVxuXG5cdFx0XHRpZiAoIHJlZGlyZWN0SW5mby5oYXNUcmFpbGluZ1NsYXNoICkge1xuXHRcdFx0XHR0YXJnZXRDbGFzc2VzLnB1c2goIFwiaGFzLXRyYWlsaW5nLXNsYXNoXCIgKTtcblx0XHRcdH1cblxuXHRcdFx0cmV0dXJuICQoIFwiPHRyPlwiICkuYXBwZW5kKFxuXHRcdFx0XHQkKCBcIjx0aD5cIiApLmFkZENsYXNzKCBcImNoZWNrLWNvbHVtblwiICkuYXR0ciggXCJzY29wZVwiLCBcInJvd1wiICkuYXBwZW5kKFxuXHRcdFx0XHRcdCQoIFwiPGlucHV0PlwiIClcblx0XHRcdFx0XHRcdC5hdHRyKCBcIm5hbWVcIiwgXCJ3cHNlb19yZWRpcmVjdHNfYnVsa19kZWxldGVbXVwiIClcblx0XHRcdFx0XHRcdC5hdHRyKCBcInR5cGVcIiwgXCJjaGVja2JveFwiIClcblx0XHRcdFx0XHRcdC52YWwoIF8uZXNjYXBlKCBvbGRVcmwgKSApXG5cdFx0XHRcdClcblx0XHRcdCkuYXBwZW5kKFxuXHRcdFx0XHQkKCBcIjx0ZD5cIiApLmFkZENsYXNzKCBcInR5cGUgY29sdW1uLXR5cGUgaGFzLXJvdy1hY3Rpb25zIGNvbHVtbi1wcmltYXJ5XCIgKS5hcHBlbmQoXG5cdFx0XHRcdFx0JCggXCI8ZGl2PlwiICkuYWRkQ2xhc3MoIFwidmFsIHR5cGVcIiApLmh0bWwoIF8uZXNjYXBlKCByZWRpcmVjdFR5cGUgKSApXG5cdFx0XHRcdCkuYXBwZW5kKFxuXHRcdFx0XHRcdCQoIFwiPGRpdj5cIiApLmFkZENsYXNzKCBcInJvdy1hY3Rpb25zXCIgKS5hcHBlbmQoXG5cdFx0XHRcdFx0XHQkKCBcIjxzcGFuPlwiICkuYWRkQ2xhc3MoIFwiZWRpdFwiICkuYXBwZW5kKFxuXHRcdFx0XHRcdFx0XHQkKCBcIjxhPlwiICkuYXR0ciggeyBocmVmOiBcIiNcIiwgcm9sZTogXCJidXR0b25cIiwgXCJjbGFzc1wiOiBcInJlZGlyZWN0LWVkaXRcIiB9ICkuaHRtbCggd3BzZW9QcmVtaXVtU3RyaW5ncy5lZGl0QWN0aW9uIClcblx0XHRcdFx0XHRcdCkuYXBwZW5kKCBcIiB8IFwiIClcblx0XHRcdFx0XHQpLmFwcGVuZChcblx0XHRcdFx0XHRcdCQoIFwiPHNwYW4+XCIgKS5hZGRDbGFzcyggXCJ0cmFzaFwiICkuYXBwZW5kKFxuXHRcdFx0XHRcdFx0XHQkKCBcIjxhPlwiICkuYXR0ciggeyBocmVmOiBcIiNcIiwgcm9sZTogXCJidXR0b25cIiwgXCJjbGFzc1wiOiBcInJlZGlyZWN0LWRlbGV0ZVwiIH0gKS5odG1sKCB3cHNlb1ByZW1pdW1TdHJpbmdzLmRlbGV0ZUFjdGlvbiApXG5cdFx0XHRcdFx0XHQpXG5cdFx0XHRcdFx0KVxuXHRcdFx0XHQpXG5cdFx0XHQpLmFwcGVuZChcblx0XHRcdFx0JCggXCI8dGQ+XCIgKS5hZGRDbGFzcyggXCJjb2x1bW4tb2xkXCIgKS5hcHBlbmQoXG5cdFx0XHRcdFx0JCggXCI8ZGl2PlwiICkuYWRkQ2xhc3MoIFwidmFsXCIgKS5odG1sKCBfLmVzY2FwZSggb2xkVXJsICkgKVxuXHRcdFx0XHQpXG5cdFx0XHQpLmFwcGVuZChcblx0XHRcdFx0JCggXCI8dGQ+XCIgKS5hZGRDbGFzcyggXCJjb2x1bW4tbmV3XCIgKS5hcHBlbmQoXG5cdFx0XHRcdFx0JCggXCI8ZGl2PlwiICkuYWRkQ2xhc3MoIHRhcmdldENsYXNzZXMuam9pbiggXCIgXCIgKSApLmh0bWwoIF8uZXNjYXBlKCBuZXdVcmwgKSApXG5cdFx0XHRcdClcblx0XHRcdCk7XG5cdFx0fTtcblxuXHRcdC8qKlxuXHRcdCAqIEhhbmRsZXMgdGhlIGVycm9yLlxuXHRcdCAqXG5cdFx0ICogQHBhcmFtIHtWYWxpZGF0ZVJlZGlyZWN0fSB2YWxpZGF0ZVJlZGlyZWN0IFRoZSB2YWxpZGF0aW9uIG9iamVjdC5cblx0XHQgKiBAcGFyYW0ge09iamVjdH0gICAgICAgICAgIGVycm9yICAgICAgICAgICAgVGhlIGVycm9yIG9iamVjdC5cblx0XHQgKlxuXHRcdCAqIEByZXR1cm5zIHt2b2lkfVxuXHRcdCAqL1xuXHRcdHRoaXMuaGFuZGxlRXJyb3IgPSBmdW5jdGlvbiggdmFsaWRhdGVSZWRpcmVjdCwgZXJyb3IgKSB7XG5cdFx0XHR2YWxpZGF0ZVJlZGlyZWN0LmFkZFZhbGlkYXRpb25FcnJvciggZXJyb3IubWVzc2FnZSwgZXJyb3IuZmllbGRzICk7XG5cblx0XHRcdGlmICggZXJyb3IudHlwZSA9PT0gXCJ3YXJuaW5nXCIgKSB7XG5cdFx0XHRcdHRoYXQuZGlhbG9nKCB3cHNlb1ByZW1pdW1TdHJpbmdzLmVycm9yX3NhdmluZ19yZWRpcmVjdCwgZXJyb3IubWVzc2FnZSwgZXJyb3IudHlwZSApO1xuXHRcdFx0fVxuXHRcdH07XG5cblx0XHQvKipcblx0XHQgKiBBZGRpbmcgdGhlIHJlZGlyZWN0XG5cdFx0ICpcblx0XHQgKiBAcmV0dXJucyB7Ym9vbGVhbn0gVHJ1ZSB3aGVuIHJlZGlyZWN0IGhhcyBiZWVuIGFkZGVkIHN1Y2Nlc3NmdWxseS5cblx0XHQgKi9cblx0XHR0aGlzLmFkZFJlZGlyZWN0ID0gZnVuY3Rpb24oKSB7XG5cdFx0XHQvLyBEbyB0aGUgdmFsaWRhdGlvbi5cblx0XHRcdGNvbnN0IHJlZGlyZWN0Rm9ybSAgICAgPSBuZXcgUmVkaXJlY3RGb3JtKCAkKCBcIi53cHNlby1uZXctcmVkaXJlY3QtZm9ybVwiICkgKTtcblx0XHRcdGNvbnN0IHZhbGlkYXRlUmVkaXJlY3QgPSBuZXcgVmFsaWRhdGVSZWRpcmVjdCggcmVkaXJlY3RGb3JtLCByZWRpcmVjdEZvcm1hdCApO1xuXHRcdFx0aWYgKCB2YWxpZGF0ZVJlZGlyZWN0LnZhbGlkYXRlKCkgPT09IGZhbHNlICkge1xuXHRcdFx0XHRyZXR1cm4gZmFsc2U7XG5cdFx0XHR9XG5cblx0XHRcdGNvbnN0IHJlZGlyZWN0VmFsdWVzID0gdmFsaWRhdGVSZWRpcmVjdC5nZXRGb3JtVmFsdWVzKCk7XG5cblx0XHRcdC8vIERvIHBvc3QuXG5cdFx0XHR0aGF0LnBvc3QoXG5cdFx0XHRcdHtcblx0XHRcdFx0XHRhY3Rpb246IFwid3BzZW9fYWRkX3JlZGlyZWN0X1wiICsgcmVkaXJlY3RGb3JtYXQsXG5cdFx0XHRcdFx0LyogZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGNhbWVsY2FzZSAqL1xuXHRcdFx0XHRcdGFqYXhfbm9uY2U6ICQoIFwiLndwc2VvX3JlZGlyZWN0c19hamF4X25vbmNlXCIgKS52YWwoKSxcblx0XHRcdFx0XHRyZWRpcmVjdDoge1xuXHRcdFx0XHRcdFx0b3JpZ2luOiBlbmNvZGVVUklDb21wb25lbnQoIHJlZGlyZWN0VmFsdWVzLm9yaWdpbiApLFxuXHRcdFx0XHRcdFx0dGFyZ2V0OiBlbmNvZGVVUklDb21wb25lbnQoIHJlZGlyZWN0VmFsdWVzLnRhcmdldCApLFxuXHRcdFx0XHRcdFx0dHlwZTogcmVkaXJlY3RWYWx1ZXMudHlwZSxcblx0XHRcdFx0XHR9LFxuXHRcdFx0XHRcdC8qIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBjYW1lbGNhc2UgKi9cblx0XHRcdFx0XHRpZ25vcmVfd2FybmluZzogaWdub3JlLFxuXHRcdFx0XHR9LFxuXHRcdFx0XHRmdW5jdGlvbiggcmVzcG9uc2UgKSB7XG5cdFx0XHRcdFx0aWYgKCByZXNwb25zZS5lcnJvciApIHtcblx0XHRcdFx0XHRcdHRoYXQuaGFuZGxlRXJyb3IoIHZhbGlkYXRlUmVkaXJlY3QsIHJlc3BvbnNlLmVycm9yICk7XG5cblx0XHRcdFx0XHRcdHJldHVybiB0cnVlO1xuXHRcdFx0XHRcdH1cblxuXHRcdFx0XHRcdC8vIEVtcHR5IHRoZSBmb3JtIGZpZWxkcy5cblx0XHRcdFx0XHRyZWRpcmVjdEZvcm0uZ2V0T3JpZ2luRmllbGQoKS52YWwoIFwiXCIgKTtcblx0XHRcdFx0XHRyZWRpcmVjdEZvcm0uZ2V0VGFyZ2V0RmllbGQoKS52YWwoIFwiXCIgKTtcblxuXHRcdFx0XHRcdC8vIFJlbW92ZSB0aGUgbm8gaXRlbXMgcm93LlxuXHRcdFx0XHRcdHRoYXQuZmluZCggXCIubm8taXRlbXNcIiApLnJlbW92ZSgpO1xuXG5cdFx0XHRcdFx0Ly8gQ3JlYXRpbmcgdHIuXG5cdFx0XHRcdFx0Y29uc3QgdHIgPSB0aGF0LmNyZWF0ZVJlZGlyZWN0Um93KCByZXNwb25zZS5vcmlnaW4sIHJlc3BvbnNlLnRhcmdldCwgcmVzcG9uc2UudHlwZSwgcmVzcG9uc2UuaW5mbyApO1xuXG5cdFx0XHRcdFx0Ly8gQWRkIHRoZSBuZXcgcm93LlxuXHRcdFx0XHRcdCQoIFwiZm9ybSNcIiArIHJlZGlyZWN0Rm9ybWF0ICkuZmluZCggXCIjdGhlLWxpc3RcIiApLnByZXBlbmQoIHRyICk7XG5cblx0XHRcdFx0XHR0aGF0Lm9wZW5EaWFsb2coIHdwc2VvUHJlbWl1bVN0cmluZ3MucmVkaXJlY3RfYWRkZWQgKTtcblx0XHRcdFx0fVxuXHRcdFx0KTtcblxuXHRcdFx0cmV0dXJuIHRydWU7XG5cdFx0fTtcblxuXHRcdC8qKlxuXHRcdCAqIFVwZGF0aW5nIHRoZSByZWRpcmVjdFxuXHRcdCAqXG5cdFx0ICogQHJldHVybnMge2Jvb2xlYW59IFRydWUgd2hlbiB1cGRhdGVzIGlzIHN1Y2Nlc3NmdWwuXG5cdFx0ICovXG5cdFx0dGhpcy51cGRhdGVSZWRpcmVjdCA9IGZ1bmN0aW9uKCkge1xuXHRcdFx0Ly8gRG8gdGhlIHZhbGlkYXRpb24uXG5cdFx0XHRjb25zdCByZWRpcmVjdEZvcm0gICAgID0gbmV3IFJlZGlyZWN0Rm9ybSggcmVkaXJlY3RzUXVpY2tFZGl0LmdldEZvcm0oKSApO1xuXHRcdFx0Y29uc3QgdmFsaWRhdGVSZWRpcmVjdCA9IG5ldyBWYWxpZGF0ZVJlZGlyZWN0KCByZWRpcmVjdEZvcm0sIHJlZGlyZWN0Rm9ybWF0ICk7XG5cdFx0XHRpZiAoIHZhbGlkYXRlUmVkaXJlY3QudmFsaWRhdGUoKSA9PT0gZmFsc2UgKSB7XG5cdFx0XHRcdHJldHVybiBmYWxzZTtcblx0XHRcdH1cblxuXHRcdFx0Y29uc3QgcmVkaXJlY3RWYWx1ZXMgPSB2YWxpZGF0ZVJlZGlyZWN0LmdldEZvcm1WYWx1ZXMoKTtcblxuXHRcdFx0Ly8gU2V0dGluZyB0aGUgdmFycyBmb3IgdGhlIHJvdyBhbmQgaXRzIHZhbHVlcy5cblx0XHRcdGNvbnN0IHJvdyA9IHJlZGlyZWN0c1F1aWNrRWRpdC5nZXRSb3coKTtcblx0XHRcdGNvbnN0IHJvd0NlbGxzID0gdGhpcy5yb3dDZWxscyggcm93ICk7XG5cblx0XHRcdC8vIFBvc3QgdGhlIHJlcXVlc3QuXG5cdFx0XHR0aGF0LnBvc3QoXG5cdFx0XHRcdHtcblx0XHRcdFx0XHQvKiBlc2xpbnQtZGlzYWJsZSBjYW1lbGNhc2UgKi9cblx0XHRcdFx0XHRhY3Rpb246IFwid3BzZW9fdXBkYXRlX3JlZGlyZWN0X1wiICsgcmVkaXJlY3RGb3JtYXQsXG5cdFx0XHRcdFx0YWpheF9ub25jZTogJCggXCIud3BzZW9fcmVkaXJlY3RzX2FqYXhfbm9uY2VcIiApLnZhbCgpLFxuXHRcdFx0XHRcdG9sZF9yZWRpcmVjdDoge1xuXHRcdFx0XHRcdFx0b3JpZ2luOiBlbmNvZGVVUklDb21wb25lbnQoIHJvd0NlbGxzLm9yaWdpbi5odG1sKCkgKSxcblx0XHRcdFx0XHRcdHRhcmdldDogZW5jb2RlVVJJQ29tcG9uZW50KCByb3dDZWxscy50YXJnZXQuaHRtbCgpICksXG5cdFx0XHRcdFx0XHR0eXBlOiBlbmNvZGVVUklDb21wb25lbnQoIHJvd0NlbGxzLnR5cGUuaHRtbCgpICksXG5cdFx0XHRcdFx0fSxcblx0XHRcdFx0XHRuZXdfcmVkaXJlY3Q6IHtcblx0XHRcdFx0XHRcdG9yaWdpbjogZW5jb2RlVVJJQ29tcG9uZW50KCByZWRpcmVjdFZhbHVlcy5vcmlnaW4gKSxcblx0XHRcdFx0XHRcdHRhcmdldDogZW5jb2RlVVJJQ29tcG9uZW50KCByZWRpcmVjdFZhbHVlcy50YXJnZXQgKSxcblx0XHRcdFx0XHRcdHR5cGU6IGVuY29kZVVSSUNvbXBvbmVudCggcmVkaXJlY3RWYWx1ZXMudHlwZSApLFxuXHRcdFx0XHRcdH0sXG5cdFx0XHRcdFx0aWdub3JlX3dhcm5pbmc6IGlnbm9yZSxcblx0XHRcdFx0fSxcblx0XHRcdFx0ZnVuY3Rpb24oIHJlc3BvbnNlICkge1xuXHRcdFx0XHRcdGlmICggcmVzcG9uc2UuZXJyb3IgKSB7XG5cdFx0XHRcdFx0XHR0aGF0LmhhbmRsZUVycm9yKCB2YWxpZGF0ZVJlZGlyZWN0LCByZXNwb25zZS5lcnJvciApO1xuXG5cdFx0XHRcdFx0XHRyZXR1cm4gdHJ1ZTtcblx0XHRcdFx0XHR9XG5cblx0XHRcdFx0XHQvLyBVcGRhdGVzIHRoZSB0YWJsZSBjZWxscy5cblx0XHRcdFx0XHRyb3dDZWxscy5vcmlnaW4uaHRtbCggXy5lc2NhcGUoIHJlc3BvbnNlLm9yaWdpbiApICk7XG5cdFx0XHRcdFx0cm93Q2VsbHMudGFyZ2V0Lmh0bWwoIF8uZXNjYXBlKCByZXNwb25zZS50YXJnZXQgKSApO1xuXHRcdFx0XHRcdHJvd0NlbGxzLnR5cGUuaHRtbCggXy5lc2NhcGUoIHJlc3BvbnNlLnR5cGUgKSApO1xuXG5cdFx0XHRcdFx0cmVkaXJlY3RzUXVpY2tFZGl0LnJlbW92ZSgpO1xuXG5cdFx0XHRcdFx0dGhhdC5vcGVuRGlhbG9nKCB3cHNlb1ByZW1pdW1TdHJpbmdzLnJlZGlyZWN0X3VwZGF0ZWQgKTtcblx0XHRcdFx0fVxuXHRcdFx0XHQvKiBlc2xpbnQtZW5hYmxlIGNhbWVsY2FzZSAqL1xuXHRcdFx0KTtcblxuXHRcdFx0cmV0dXJuIHRydWU7XG5cdFx0fTtcblxuXHRcdC8qKlxuXHRcdCAqIFJlbW92ZXMgdGhlIHJlZGlyZWN0XG5cdFx0ICpcblx0XHQgKiBAcGFyYW0ge09iamVjdH0gcm93IFRoZSByb3cgb2JqZWN0LlxuXHRcdCAqXG5cdFx0ICogQHJldHVybnMge3ZvaWR9XG5cdFx0ICovXG5cdFx0dGhpcy5kZWxldGVSZWRpcmVjdCA9IGZ1bmN0aW9uKCByb3cgKSB7XG5cdFx0XHRjb25zdCByb3dDZWxscyA9IHRoaXMucm93Q2VsbHMoIHJvdyApO1xuXG5cdFx0XHRjb25zdCBvcmlnaW4gICAgICAgPSByb3dDZWxscy5vcmlnaW4uaHRtbCgpO1xuXHRcdFx0Y29uc3QgdGFyZ2V0ICAgICAgID0gcm93Q2VsbHMudGFyZ2V0Lmh0bWwoKTtcblx0XHRcdGNvbnN0IHJlZGlyZWN0VHlwZSA9IHJvd0NlbGxzLnR5cGUuaHRtbCgpO1xuXG5cdFx0XHR3cHNlb0RlbGV0ZVJlZGlyZWN0KFxuXHRcdFx0XHRvcmlnaW4sXG5cdFx0XHRcdHRhcmdldCxcblx0XHRcdFx0cmVkaXJlY3RUeXBlLFxuXHRcdFx0XHRyZWRpcmVjdEZvcm1hdCxcblx0XHRcdCkudGhlbiggKCByZXNwb25zZSApID0+IHtcblx0XHRcdFx0Ly8gV2hlbiB0aGUgcmVkaXJlY3QgaXMgcmVtb3ZlZCwganVzdCBmYWRlIG91dCB0aGUgcm93IGFuZCByZW1vdmUgaXQgYWZ0ZXIgaXRzIGZhZGVkLlxuXHRcdFx0XHRyb3cuZmFkZVRvKCBcImZhc3RcIiwgMCApLnNsaWRlVXAoIGZ1bmN0aW9uKCkge1xuXHRcdFx0XHRcdCQoIHRoaXMgKS5yZW1vdmUoKTtcblx0XHRcdFx0fSApO1xuXG5cdFx0XHRcdHRoYXQub3BlbkRpYWxvZyggcmVzcG9uc2UgKTtcblx0XHRcdH0gKS5jYXRjaCggKCBlcnJvciApID0+IHtcblx0XHRcdFx0dGhpcy5kaWFsb2coIGVycm9yLnRpdGxlLCBlcnJvci5tZXNzYWdlLCBcImVycm9yXCIgKTtcblx0XHRcdH0gKTtcblx0XHR9O1xuXG5cdFx0LyoqXG5cdFx0ICogUnVubmluZyB0aGUgc2V0dXAgb2YgdGhpcyBlbGVtZW50LlxuXHRcdCAqXG5cdFx0ICogQHJldHVybnMge3ZvaWR9XG5cdFx0ICovXG5cdFx0dGhpcy5zZXR1cCA9IGZ1bmN0aW9uKCkge1xuXHRcdFx0bGV0ICRyb3c7XG5cdFx0XHQvLyBBZGRpbmcgZGlhbG9nLlxuXHRcdFx0JCggXCJib2R5XCIgKS5hcHBlbmQoIFwiPGRpdiBpZD1cXFwiWW9hc3RSZWRpcmVjdERpYWxvZ1xcXCI+PGRpdiBpZD1cXFwiWW9hc3RSZWRpcmVjdERpYWxvZ1RleHRcXFwiPjwvZGl2PjwvZGl2PlwiICk7XG5cblx0XHRcdC8vIFdoZW4gdGhlIHdpbmRvdyB3aWxsIGJlIGNsb3NlZC9yZWxvYWRlZCBhbmQgdGhlcmUgaXMgYSBpbmxpbmUgZWRpdCBvcGVuZWQgc2hvdyBhIG1lc3NhZ2UuXG5cdFx0XHQkKCB3aW5kb3cgKS5vbiggXCJiZWZvcmV1bmxvYWRcIixcblx0XHRcdFx0ZnVuY3Rpb24oKSB7XG5cdFx0XHRcdFx0aWYgKCAkKCBcIiN0aGUtbGlzdFwiICkuZmluZCggXCIjaW5saW5lLWVkaXRcIiApLmxlbmd0aCA+IDAgKSB7XG5cdFx0XHRcdFx0XHRyZXR1cm4gd3BzZW9QcmVtaXVtU3RyaW5ncy51bnNhdmVkX3JlZGlyZWN0cztcblx0XHRcdFx0XHR9XG5cdFx0XHRcdH1cblx0XHRcdCk7XG5cblx0XHRcdC8vIEFkZGluZyB0aGUgb25jaGFuZ2UgZXZlbnQuXG5cdFx0XHQkKCBcIi5yZWRpcmVjdC10YWJsZS10YWJcIiApXG5cdFx0XHRcdC5vbiggXCJjaGFuZ2VcIiwgXCJzZWxlY3RbbmFtZT13cHNlb19yZWRpcmVjdHNfdHlwZV1cIiwgKCBldnQgKSA9PiB7XG5cdFx0XHRcdFx0Y29uc3QgcmVkaXJlY3RUeXBlID0gcGFyc2VJbnQoICQoIGV2dC50YXJnZXQgKS52YWwoKSwgMTAgKTtcblx0XHRcdFx0XHRjb25zdCBmaWVsZFRvVG9nZ2xlID0gJCggZXZ0LnRhcmdldCApLmNsb3Nlc3QoIFwiLndwc2VvX3JlZGlyZWN0X2Zvcm1cIiApLmZpbmQoIFwiLndwc2VvX3JlZGlyZWN0X3RhcmdldF9ob2xkZXJcIiApO1xuXG5cdFx0XHRcdFx0Ly8gSGlkZSB0aGUgdGFyZ2V0IGZpZWxkIGluIGNhc2Ugb2YgYSA0MTAgcmVkaXJlY3QuXG5cdFx0XHRcdFx0aWYgKCBqUXVlcnkuaW5BcnJheSggcmVkaXJlY3RUeXBlLCBBTExPV19FTVBUWV9UQVJHRVQgKSA+IC0xICkge1xuXHRcdFx0XHRcdFx0JCggZmllbGRUb1RvZ2dsZSApLmhpZGUoKTtcblxuXHRcdFx0XHRcdFx0cmV0dXJuO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0XHQkKCBmaWVsZFRvVG9nZ2xlICkuc2hvdygpO1xuXHRcdFx0XHR9ICk7XG5cblx0XHRcdC8vIEFkZGluZyBldmVudHMgZm9yIHRoZSBhZGQgZm9ybS5cblx0XHRcdCQoIFwiLndwc2VvLW5ldy1yZWRpcmVjdC1mb3JtXCIgKVxuXHRcdFx0XHQub24oIFwiY2xpY2tcIiwgXCIuYnV0dG9uLXByaW1hcnlcIiwgZnVuY3Rpb24oKSB7XG5cdFx0XHRcdFx0bGFzdEFjdGlvbiA9IGZ1bmN0aW9uKCkge1xuXHRcdFx0XHRcdFx0dGhhdC5hZGRSZWRpcmVjdCgpO1xuXHRcdFx0XHRcdH07XG5cblx0XHRcdFx0XHR0aGF0LmFkZFJlZGlyZWN0KCk7XG5cdFx0XHRcdFx0cmV0dXJuRm9jdXNUb0VsID0gJCggdGhpcyApO1xuXHRcdFx0XHRcdHJldHVybiBmYWxzZTtcblx0XHRcdFx0fSApXG5cdFx0XHRcdC5vbiggXCJrZXlwcmVzc1wiLCBcImlucHV0XCIsIGZ1bmN0aW9uKCBldnQgKSB7XG5cdFx0XHRcdFx0aWYgKCBldnQud2hpY2ggPT09IEtFWVMuRU5URVIgKSB7XG5cdFx0XHRcdFx0XHRsYXN0QWN0aW9uID0gZnVuY3Rpb24oKSB7XG5cdFx0XHRcdFx0XHRcdHRoYXQuYWRkUmVkaXJlY3QoKTtcblx0XHRcdFx0XHRcdH07XG5cblx0XHRcdFx0XHRcdGV2dC5wcmV2ZW50RGVmYXVsdCgpO1xuXHRcdFx0XHRcdFx0dGhhdC5hZGRSZWRpcmVjdCgpO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fSApO1xuXG5cdFx0XHQkKCBcIi53cC1saXN0LXRhYmxlXCIgKVxuXHRcdFx0XHQub24oIFwiY2xpY2tcIiwgXCIucmVkaXJlY3QtZWRpdFwiLCBmdW5jdGlvbiggZXZ0ICkge1xuXHRcdFx0XHRcdCRyb3cgPSAkKCBldnQudGFyZ2V0ICkuY2xvc2VzdCggXCJ0clwiICk7XG5cblx0XHRcdFx0XHRldnQucHJldmVudERlZmF1bHQoKTtcblx0XHRcdFx0XHR0aGF0LmVkaXRSb3coICRyb3cgKTtcblx0XHRcdFx0XHRyZXR1cm5Gb2N1c1RvRWwgPSAkKCB0aGlzICk7XG5cdFx0XHRcdH0gKVxuXHRcdFx0XHQub24oIFwiY2xpY2tcIiwgXCIucmVkaXJlY3QtZGVsZXRlXCIsIGZ1bmN0aW9uKCBldnQgKSB7XG5cdFx0XHRcdFx0JHJvdyA9ICQoIGV2dC50YXJnZXQgKS5jbG9zZXN0KCBcInRyXCIgKTtcblxuXHRcdFx0XHRcdGV2dC5wcmV2ZW50RGVmYXVsdCgpO1xuXHRcdFx0XHRcdHRoYXQuZGVsZXRlUmVkaXJlY3QoICRyb3cgKTtcblx0XHRcdFx0XHQvLyBXaGVuIGEgcm93IGdldHMgZGVsZXRlZCwgd2hlcmUgZm9jdXMgc2hvdWxkIGxhbmQ/XG5cdFx0XHRcdFx0cmV0dXJuRm9jdXNUb0VsID0gJCggXCIjY2Itc2VsZWN0LWFsbC0xXCIgKTtcblx0XHRcdFx0fSApXG5cdFx0XHRcdC5vbiggXCJrZXlwcmVzc1wiLCBcImlucHV0XCIsIGZ1bmN0aW9uKCBldnQgKSB7XG5cdFx0XHRcdFx0aWYgKCBldnQud2hpY2ggPT09IEtFWVMuRU5URVIgKSB7XG5cdFx0XHRcdFx0XHRsYXN0QWN0aW9uID0gZnVuY3Rpb24oKSB7XG5cdFx0XHRcdFx0XHRcdHRoYXQudXBkYXRlUmVkaXJlY3QoKTtcblx0XHRcdFx0XHRcdH07XG5cblx0XHRcdFx0XHRcdGV2dC5wcmV2ZW50RGVmYXVsdCgpO1xuXHRcdFx0XHRcdFx0dGhhdC51cGRhdGVSZWRpcmVjdCgpO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fSApXG5cdFx0XHRcdC5vbiggXCJjbGlja1wiLCBcIi5zYXZlXCIsIGZ1bmN0aW9uKCkge1xuXHRcdFx0XHRcdGxhc3RBY3Rpb24gPSBmdW5jdGlvbigpIHtcblx0XHRcdFx0XHRcdHRoYXQudXBkYXRlUmVkaXJlY3QoKTtcblx0XHRcdFx0XHR9O1xuXG5cdFx0XHRcdFx0bGFzdEFjdGlvbigpO1xuXHRcdFx0XHR9IClcblx0XHRcdFx0Lm9uKCBcImNsaWNrXCIsIFwiLmNhbmNlbFwiLCBmdW5jdGlvbigpIHtcblx0XHRcdFx0XHRsYXN0QWN0aW9uID0gbnVsbDtcblx0XHRcdFx0XHRyZWRpcmVjdHNRdWlja0VkaXQucmVtb3ZlKCk7XG5cdFx0XHRcdFx0Ly8gTW92ZSBmb2N1cyBiYWNrIHRvIHRoZSBFZGl0IGxpbmsuXG5cdFx0XHRcdFx0JHJvdy5maW5kKCBcIi5yZWRpcmVjdC1lZGl0XCIgKS5mb2N1cygpO1xuXHRcdFx0XHR9ICk7XG5cdFx0fTtcblxuXHRcdHRoYXQuc2V0dXAoKTtcblx0fTtcblxuXHQvKipcblx0ICogQWRkcyBzZWxlY3QyIGZvciBzZWxlY3RlZCBmaWVsZHMuXG5cdCAqXG5cdCAqIEByZXR1cm5zIHt2b2lkfVxuXHQgKi9cblx0ZnVuY3Rpb24gaW5pdFNlbGVjdDIoKSB7XG5cdFx0JCggXCIjd3BzZW9fcmVkaXJlY3RzX3R5cGVcIiApLnNlbGVjdDIoIHtcblx0XHRcdHdpZHRoOiBcIjQwMHB4XCIsXG5cdFx0XHRsYW5ndWFnZTogd3BzZW9Vc2VyTG9jYWxlLFxuXHRcdFx0ZHJvcGRvd25Dc3NDbGFzczogXCJ5b2FzdC1zZWxlY3RfX2Ryb3Bkb3duXCIsXG5cdFx0fSApO1xuXHR9XG5cblx0LyoqXG5cdCAqIEluaXRpYWxpemVzIHRoZSByZWRpcmVjdCBwYWdlLlxuXHQgKlxuXHQgKiBAcmV0dXJucyB7dm9pZH1cblx0ICovXG5cdGZ1bmN0aW9uIGluaXQoKSB7XG5cdFx0JC5lYWNoKFxuXHRcdFx0JCggXCIucmVkaXJlY3QtdGFibGUtdGFiXCIgKSxcblx0XHRcdGZ1bmN0aW9uKCBrZXksIGVsZW1lbnQgKSB7XG5cdFx0XHRcdCQoIGVsZW1lbnQgKS53cHNlb1JlZGlyZWN0cyggJCggZWxlbWVudCApLmF0dHIoIFwiaWRcIiApICk7XG5cdFx0XHR9XG5cdFx0KTtcblxuXHRcdGluaXRTZWxlY3QyKCk7XG5cdH1cblxuXHQkKCBpbml0ICk7XG59KCBqUXVlcnkgKSApO1xuIl0sIm1hcHBpbmdzIjoiOztBQUtBO0FBQ0E7QUFBQTtBQUNBOzs7QUFBQTtBQUNBOzs7QUFBQTtBQUNBOzs7OztBQVRBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFNQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBSEE7QUFDQTtBQUtBO0FBQ0E7QUFEQTtBQUNBO0FBR0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7O0FBT0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7O0FBT0E7QUFDQTtBQUNBO0FBVkE7QUFZQTtBQUNBO0FBekJBO0FBQ0E7QUEyQkE7Ozs7Ozs7QUFPQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7OztBQUtBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7QUFRQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7O0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFmQTtBQWlCQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBR0E7QUFEQTtBQUtBO0FBQ0E7QUFDQTtBQUdBO0FBREE7QUFJQTtBQUNBO0FBSUE7QUFDQTtBQUZBO0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFHQTtBQUNBO0FBQ0E7Ozs7OztBQU1BO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBSEE7QUFLQTtBQUNBO0FBQ0E7Ozs7Ozs7OztBQVNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFIQTtBQUtBO0FBQ0E7QUFDQTs7Ozs7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBckJBO0FBd0JBO0FBQ0E7QUFDQTs7Ozs7OztBQU9BO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7O0FBUUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7OztBQU9BO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFJQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7O0FBU0E7QUFDQTtBQUNBO0FBQ0E7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBOEJBO0FBQ0E7QUFDQTs7Ozs7Ozs7QUFRQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7O0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFIQTtBQUtBO0FBQ0E7QUFWQTtBQWFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7Ozs7O0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUhBO0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFIQTtBQUtBO0FBZEE7QUFpQkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFqQ0E7QUFDQTtBQW1DQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7OztBQU9BO0FBQUE7QUFDQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBTUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7OztBQUtBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7O0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUhBO0FBS0E7QUFDQTtBQUNBOzs7OztBQUtBO0FBQ0E7QUFHQTtBQUNBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///85\n')},86:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n  value: true\n});\n/**\n * Initialize a redirect form object.\n *\n * @param {element} form The redirect form.\n * @constructor\n */\nvar RedirectForm = function RedirectForm(form) {\n  this.form = form;\n};\n\n/**\n * Returns the origin field.\n *\n * @returns {element} The field for the redirect origin.\n */\nRedirectForm.prototype.getOriginField = function () {\n  return this.form.find("input[name=wpseo_redirects_origin]");\n};\n\n/**\n * Returns the target field.\n *\n * @returns {element} The field for the redirect target.\n */\nRedirectForm.prototype.getTargetField = function () {\n  return this.form.find("input[name=wpseo_redirects_target]");\n};\n\n/**\n * Returns the type field.\n *\n * @returns {element} The field for redirect type.\n */\nRedirectForm.prototype.getTypeField = function () {\n  return this.form.find("select[name=wpseo_redirects_type]");\n};\n\n/**\n * Clears the form error message.\n *\n * @returns {void}\n */\nRedirectForm.prototype.clearErrorMessage = function () {\n  this.form.find(".wpseo_redirect_form .form_error").remove();\n};\n\n/**\n * Sets a form error message.\n *\n * @param {string} errorMessage The error message to set.\n *\n * @returns {void}\n */\nRedirectForm.prototype.setErrorMessage = function (errorMessage) {\n  this.form.find(".wpseo_redirect_form").prepend("<div class=\\"form_error error\\"><p>" + errorMessage + "</p></div>");\n};\n\n/**\n * Removing the row errors.\n *\n * @returns {void}\n */\nRedirectForm.prototype.removeRowHighlights = function () {\n  this.form.find(".redirect_form_row").removeClass("field_error");\n};\n\n/**\n * Highlighting the row errors.\n *\n * @param {array} fieldsToHighlight The fields to highlight.\n *\n * @returns {void}\n */\nRedirectForm.prototype.highLightRowErrors = function (fieldsToHighlight) {\n  for (var i = 0; i < fieldsToHighlight.length; i++) {\n    switch (fieldsToHighlight[i]) {\n      case "origin":\n        this.highlightRow(this.getOriginField());\n        break;\n      case "target":\n        this.highlightRow(this.getTargetField());\n        break;\n      case "type":\n        this.highlightRow(this.getTypeField());\n        break;\n    }\n  }\n};\n\n/**\n * Highlights the closest row with an error class.\n *\n * @param {element} errorField The field to hightlight.\n *\n * @returns {void}\n */\nRedirectForm.prototype.highlightRow = function (errorField) {\n  jQuery(errorField).closest("div.redirect_form_row").addClass("field_error");\n};\n\nexports.default = RedirectForm;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///86\n')},87:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _functions = __webpack_require__(13);\n\n/**\n * Client side validator for the redirect.\n *\n * @param {RedirectForm} form Form object representing the form.\n * @param {string} type       The redirect type.\n *\n * @returns {void}\n */\nvar ValidateRedirect = function ValidateRedirect(form, type) {\n\tthis.form = form;\n\tthis.type = type;\n\tthis.validationError = "";\n};\n\n/**\n * Validates the form fields.\n *\n * @returns {boolean} True when validation has been successful.\n */\n/* global wpseoPremiumStrings */\nValidateRedirect.prototype.validate = function () {\n\tthis.form.clearErrorMessage();\n\tthis.form.removeRowHighlights();\n\n\tif (this.runValidation(this.form.getOriginField(), this.form.getTargetField(), this.form.getTypeField()) === false) {\n\t\tthis.addValidationError(this.validationError);\n\n\t\treturn false;\n\t}\n\n\treturn true;\n};\n\n/**\n * Executes the validation.\n *\n * @param {element} originField The origin field.\n * @param {element} targetField The target field.\n * @param {element} typeField   The type field.\n * @returns {boolean} True when validation has been successful.\n */\nValidateRedirect.prototype.runValidation = function (originField, targetField, typeField) {\n\t// Check old URL.\n\tif ("" === originField.val()) {\n\t\tthis.form.highlightRow(originField);\n\n\t\tif ("plain" === this.type) {\n\t\t\treturn this.setError(wpseoPremiumStrings.error_old_url);\n\t\t}\n\n\t\treturn this.setError(wpseoPremiumStrings.error_regex);\n\t}\n\n\t// Only when the redirect type is not deleted.\n\tif (jQuery.inArray(parseInt(typeField.val(), 10), _functions.ALLOW_EMPTY_TARGET) === -1) {\n\t\t// Check new URL.\n\t\tif ("" === targetField.val()) {\n\t\t\tthis.form.highlightRow(targetField);\n\t\t\treturn this.setError(wpseoPremiumStrings.error_new_url);\n\t\t}\n\n\t\t// Check if both fields aren\'t the same.\n\t\tif (targetField.val() === originField.val()) {\n\t\t\tthis.form.highlightRow(targetField);\n\t\t\treturn this.setError(wpseoPremiumStrings.error_circular);\n\t\t}\n\t}\n\n\t// Check the redirect type.\n\tif ("" === typeField.val()) {\n\t\tthis.form.highlightRow(typeField);\n\t\treturn this.setError(wpseoPremiumStrings.error_new_type);\n\t}\n\n\treturn true;\n};\n\n/**\n * Sets the validation error and return false.\n *\n * @param {string} error The error to set.\n * @returns {boolean} False, because there is an error.\n */\nValidateRedirect.prototype.setError = function (error) {\n\tthis.validationError = error;\n\n\treturn false;\n};\n\n/**\n * Adding the validation error.\n *\n * @param {string} error  The error message.\n * @param {object} fields The fields related to the error.\n *\n * @returns {void}\n */\nValidateRedirect.prototype.addValidationError = function (error) {\n\tvar fields = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n\n\tthis.form.setErrorMessage(error);\n\n\tif (typeof fields !== "undefined") {\n\t\tthis.form.highLightRowErrors(fields);\n\t}\n};\n\n/**\n * Returns the values on the quick edit form.\n *\n * @returns {{origin: (string|*), target: (string|*), type: (string|*)}} Object with the form values.\n */\nValidateRedirect.prototype.getFormValues = function () {\n\tvar values = {\n\t\torigin: this.form.getOriginField().val().toString(),\n\t\ttarget: this.form.getTargetField().val().toString(),\n\t\ttype: this.form.getTypeField().val().toString()\n\t};\n\n\t// When the redirect type is deleted or unavailable, the target can be emptied.\n\tif (jQuery.inArray(parseInt(values.type, 10), _functions.ALLOW_EMPTY_TARGET) > -1) {\n\t\tvalues.target = "";\n\t}\n\n\treturn values;\n};\n\nexports.default = ValidateRedirect;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///87\n')},88:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n  value: true\n});\n/* global wp, _ */\n\n/**\n * The quick edit prototype for handling the quick edit on form rows.\n * @constructor\n */\nvar RedirectQuickEdit = function RedirectQuickEdit() {\n  this.row = null;\n  this.quickEditRow = null;\n  this.templateQuickEdit = wp.template("redirects-inline-edit");\n};\n\n/**\n * Sets up the quick edit for a row, with the given row values.\n *\n * @param {element} row     The form row object.\n * @param {object} rowCells The form row cells.\n *\n * @returns {void}\n */\nRedirectQuickEdit.prototype.setup = function (row, rowCells) {\n  this.row = row;\n  this.quickEditRow = jQuery(this.templateQuickEdit({\n    origin: _.unescape(rowCells.origin.html()),\n    target: _.unescape(rowCells.target.html()),\n    type: parseInt(rowCells.type.html(), 10),\n    suffix: jQuery("#the-list").find("tr").index(row)\n  }));\n};\n\n/**\n * Returns the original row element.\n *\n * @returns {element} The row object.\n */\nRedirectQuickEdit.prototype.getRow = function () {\n  return this.row;\n};\n\n/**\n * Returns the original form element.\n *\n * @returns {element} The form object.\n */\nRedirectQuickEdit.prototype.getForm = function () {\n  return this.quickEditRow;\n};\n\n/**\n * Shows the quick edit form and hides the redirect row.\n *\n * @returns {void}\n */\nRedirectQuickEdit.prototype.show = function () {\n  this.row.addClass("hidden");\n  this.quickEditRow.insertAfter(this.row).show(400, function () {\n    jQuery(this).find(":input").first().focus();\n  });\n};\n\n/**\n * Hides the quick edit form and show the redirect row.\n *\n * @returns {void}\n */\nRedirectQuickEdit.prototype.remove = function () {\n  this.row.removeClass("hidden");\n  this.quickEditRow.remove();\n};\n\nexports.default = RedirectQuickEdit;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///88\n')}},[[85,0]]]);