<?php

/**
* Thay giá 0đ thành liên hệ
**/
function devvn_wc_custom_get_price_html( $price, $product ) {
    if ( $product->get_price() == 0 ) {
        if ( $product->is_on_sale() && $product->get_regular_price() ) {
            $regular_price = wc_get_price_to_display( $product, array( 'qty' => 1, 'price' => $product->get_regular_price() ) );
 
            $price = wc_format_price_range( $regular_price, __( 'Free!', 'woocommerce' ) );
        } else {
            $price = '<span class="amount">' . __( 'Xin liên hệ', 'woocommerce' ) . '</span>';
        }
    }
    return $price;
}
add_filter( 'woocommerce_get_price_html', 'devvn_wc_custom_get_price_html', 10, 2 );

//dịch Breadcrumb
add_filter( 'gettext', function ( $strings ) {

$text = array(
'SHOPPING CART' => 'Giỏ hàng',
'CHECKOUT DETAILS' => 'Thanh toán',
'ORDER COMPLETE' => 'Hoàn tất',
);
$strings = str_ireplace( array_keys( $text ), $text, $strings );
return $strings;
}, 20 );

// To change add to cart text on product archives(Collection) page
add_filter( 'woocommerce_product_add_to_cart_text', 'woocommerce_custom_product_add_to_cart_text' );  
function woocommerce_custom_product_add_to_cart_text() {
    return __( 'Thêm vào giỏ', 'woocommerce' );
}

// Thay doi duong dan logo admin
function wpc_url_login(){
return "https://centerwebs.com/"; // duong dan vao website cua ban
}
add_filter('login_headerurl', 'wpc_url_login');

/*Thay đổi logo trang đăng nhập*/
function login_page_logo() {
echo '<style>.login h1 a {
background-repeat: no-repeat;
background-image: url(https://www.intercontainers.vn/wp-content/uploads/2022/03/nam-viet-software.jpg);
background-position: center center;
background-size: contain !important;
width: 100% !important;
}
</style>';
}
add_action( 'login_head', 'login_page_logo' );